function [entities] = get_entities(geom, modelOpt)

%% evaluate entities

floquet_boundaries = [];
floquet_boundaries = [floquet_boundaries; modelOpt.physics('emw').feature('pc1').selection().inputEntities];

sym_boundary = [];
sym_boundary = [sym_boundary; modelOpt.physics('emw').feature('pmc1').selection().inputEntities];

d = 220e-9;
epsilon = 5e-9;
coordBox = [-1,1; geom.mech.mirror_y - geom.mech.amech*sqrt(3)/2 ...
    - epsilon, geom.mech.mirror_y + geom.mech.amech*sqrt(3)/2 ...
    + epsilon; -epsilon, d/2+epsilon];
all_boundaries = mphselectbox(modelOpt,'geom1',coordBox, 'boundary');
real_boundaries = setdiff(all_boundaries,floquet_boundaries);
real_boundaries = setdiff(real_boundaries,sym_boundary);

all_volume = mphselectbox(modelOpt,'geom1',coordBox,'domain');

entities.acbeamSurf = real_boundaries;
entities.acbeamVol = all_volume;

end